/*
 * Renderer 3. The MIT License.
 * Copyright (c) 2022 rlkraft@pnw.edu
 * See LICENSE for details.
*/

import renderer.scene.*;
import renderer.scene.primitives.*;
import renderer.framebuffer.*;
import renderer.pipeline.*;

import java.awt.Color;

/**
   Compile and run this program. Look at its output, both
   in the console window and in the PPM file that it creates.
   <p>
   Notice in the output how clipping has changed from the previous
   renderers. In the previous renderers, clipping was done during
   rasterization. In this renderer, clipping is its own pipeline
   stage just before rasterization.
*/
public class Lines_R3
{
   public static void main(String[] args)
   {
      final Scene scene = new Scene("Lines_R3");
      final Model model = new Model("Lines");
      scene.addPosition(new Position(model));

      model.addVertex(new Vertex( 5, 4,  -6),
                      new Vertex(-1, .5, -2),
                      new Vertex( 5, 4,  -3)); // try (0, 4, -3)

      model.addColor(Color.white);

      model.addPrimitive(new LineSegment(0, 1, 0),
                         new LineSegment(1, 2, 0));

      final int width  = 100;
      final int height = 100;
      final FrameBuffer fb = new FrameBuffer(width, height, Color.darkGray);

      scene.debug = true;
      Clip.debug = true;
      Rasterize.debug = true;
      Pipeline.render(scene, fb);
      fb.dumpFB2File("Lines_R3.ppm");
   }
}
