/*
   Run this program two times. First, just run it at the
   command-line and see how long it takes to complete.

   > java TestBuffers_v2

   The run this program from the command-line and
   redirect its standard output stream to a file.

   > java TestBuffers_v2 > out2.txt

   Notice that the second time the program runs, it
   runs at least tem times faster. Why?
*/

import java.io.PrintStream;
import java.io.BufferedOutputStream;

public class TestBuffers_v2
{
   public static void main(String[] args)
   {
      PrintStream out = new PrintStream(
                            new BufferedOutputStream(
                                System.out, 512));

      final long startTime = System.currentTimeMillis();
      for (int i = 0; i < 1_000_000; ++i)
      {
         out.println(i + " hello");
      }
      final long stopTime = System.currentTimeMillis();
      System.err.println("\nWall-clock time: " + (stopTime - startTime) + " milliseconds.");
   }
}
