/*
   Try examples like
      > java Retrieve_URL_HTTP  cs.pnw.edu/~rlkraft/
      > java Retrieve_URL_HTTP  www.google.com
      > java Retrieve_URL_HTTP  en.wikipedia.org/wiki/Computer_science
      > java Retrieve_URL_HTTP  swapi.dev/api/people/3/?format=json
*/

import java.net.*;
import java.io.*;

public class Retrieve_URL_HTTP
{
   public static void main(String[] args)
   {
      final String urlString;
      if (args.length > 0)
      {
         urlString = "http://" + args[0]; // always use HTTP (try https)
      }
      else
      {
         urlString = null;
         System.err.println("Usage: java Retrieve_URL_HTTP <url>");
         System.exit(1);
      }

      try
      {
         final URL url = new URL( urlString );


         final BufferedReader bf = new BufferedReader(
                                       new InputStreamReader(
                                          url.openStream(), "latin1"));

         // Read the server's response.
         for (String oneLine; (oneLine = bf.readLine()) != null; )
         {
            System.out.println(oneLine);
         }
      }
      catch (MalformedURLException e)
      {
         System.out.println(e);
      }
      catch (IOException e)
      {
         System.out.println(e);
      }
   }
}
