/*
   Try examples like
      > java Retrieve_URL_Connection  http://cs.pnw.edu/~rlkraft/
      > java Retrieve_URL_Connection  http://www.google.com
      > java Retrieve_URL_Connection  https://en.wikipedia.org/wiki/Computer_science
      > java Retrieve_URL_Connection  https://swapi.dev/api/people/3/?format=json
*/

import java.net.*;
import java.io.*;

public class Retrieve_URL_Connection
{
   public static void main(String[] args)
   {
      final String urlString;
      if (args.length > 0)
      {
         urlString = args[0];
      }
      else
      {
         urlString = null;
         System.err.println("Usage: java Retrieve_URL_Connection <url>");
         System.exit(1);
      }

      try
      {
         final URL url = new URL( urlString );
         final URLConnection connection = url.openConnection();

         final BufferedReader bf = new BufferedReader(
                                       new InputStreamReader(
                                          connection.getInputStream(), "latin1"));

         // Read the server's response.
         for (String oneLine; (oneLine = bf.readLine()) != null; )
         {
            System.out.println(oneLine);
         }
      }
      catch (MalformedURLException e)
      {
         System.out.println(e);
      }
      catch (IOException e)
      {
         System.out.println(e);
      }
   }
}
