/*

*/

import java.util.Scanner;

/**
   This program computes the results of a CGI request.

   The request can be made from either a HTTP POST
   command or an HTTP GET command.

   This program expects to read the POST or GET data
   from its standard input stream and it writes the
   response headers and the response body to its
   standard output stream.
*/
public class CGI
{
   public static void main(String[] args)
   {
      String requestData = "";
      try (final Scanner stdin = new Scanner(System.in))
      {
         while ( stdin.hasNextLine() )
         {
            final String oneLine = stdin.nextLine();
            requestData += oneLine;
         }
      }

      // Build the HTTP response body.
      final String body = "<!doctype html>\r\n" +
                          "<html>\r\n" +
                          "<head>\r\n" +
                          "<title>Thank you!</title>\r\n" +
                          "</head>\r\n" +
                          "<body>\r\n" +
                          "<h1>Thank you!</h1>\r\n" +
                          "<p>Thank you for your data!</p>\r\n" +
                          "<p></p>\r\n" +
                          "<p style=\"" +
                                "display:inline-block;" +
                                "padding:5px;" +
                                "border-style:solid;" +
                                "border-color:black;" +
                                "border-width:1px;" +
                                "margin:10px 0px;" +
                                "background-color:#eee;" +
                          "\">\r\n" +
                          "\"" + requestData + "\"\r\n" +
                          "</p>\r\n" +
                          "<p></p>\r\n" +
                          "<p>We will protect it forever.</p>\r\n" +
                          "<hr/>\r\n" +
                          "<address>Implemented by the CGI.java class.</address>\r\n" +
                          "</body>\r\n" +
                          "</html>\r\n";

      // Send the entity body.
      System.out.print(body);
      System.out.flush();
      System.out.close();
   }
}
