/*
   This client implements only DELETE.

   This client takes

      path hostname port

   as optional command-line arguments. The
   resource named "path" is deleted from
   the server by the DELETE method.

   NOTE: The HTTP PUT and DELETE methods are not supporte3d by HTML forms.
         https://alexanderpetros.com/triptych/form-http-methods
   To test our implementations of the PUT and DELETE methods we need to
   either write a Java client or embed some JavaScript code into a web
   page.
*/

import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.net.InetAddress;
import java.net.Socket;

public class HttpClient_DELETE
{
   private static final int SERVER_PORT = 8080; // Should be above 1023.

   public static void main (String[] args)
   {
      final String path;
      if (args.length > 0)
      {
         path = args[0];
      }
      else
      {
         path = "upLoad";
      }

      final String hostName;
      if (args.length > 1)
      {
         hostName = args[1];
      }
      else
      {
         hostName = "localhost";
      }

      final int portNumber;
      if (args.length > 2)
      {
         portNumber = Integer.parseInt(args[2]);
      }
      else
      {
         portNumber = SERVER_PORT;
      }

      // Get this client's process id number (PID). This helps
      // to identify the client in TaskManager or TCPView.
      final ProcessHandle handle = ProcessHandle.current();
      final long pid = handle.pid();
      System.out.println("CLIENT: Process ID number (PID): " + pid );

      // Get the name and IP address of the local host and
      // print them on the console for information purposes.
      try
      {
         final InetAddress address = InetAddress.getLocalHost();
         System.out.println("CLIENT: Hostname: " + address.getCanonicalHostName() );
         System.out.println("CLIENT: IP address: " +address.getHostAddress() );
      }
      catch (UnknownHostException e)
      {
         System.out.println("Unable to determine this client's address.");
         System.out.println( e );
      }

      // Make a connection to the server.
      System.out.println("CLIENT: Connecting to server: " + hostName
                       + " on port " + portNumber );
      try (final Socket socket = new Socket(InetAddress.getByName(hostName),
                                            portNumber);

           final var in = new BufferedReader(
                             new InputStreamReader(
                                socket.getInputStream()));

           final var out = new PrintWriter(socket.getOutputStream()))
      {
         System.out.println("CLIENT: Connected to server.");
         // Get this client's local port number and log it to the console.
         // This helps to identify this client in the server's transcript.
         final int port = socket.getLocalPort();
         System.out.println("CLIENT: Local Port: " + port);


         // Implement an HTTP DELETE transaction.
         // Send the server the request headers.
                out.println("DELETE " + path + " HTTP/1.1\r\n");
         System.out.println("<DELETE " + path + " HTTP/1.1");
                out.println("Host: " + hostName + ":" + portNumber + "\r\n");
         System.out.println("<Host: " + hostName + ":" + portNumber);
                out.println("Connection: close\r\n");
         System.out.println("<Connection: close");
         // Add a blank line to denote end of request headers.
                out.println("\r\n");
         System.out.println("<");
                out.flush();

         // Receive the response from the server.
         try
         {
            String oneLine;
            // Read the response line and response headers.
            while ( (oneLine = in.readLine()) != null ) // read up to eof or a blank line
            {
               System.out.println(">" + oneLine);
               if ( oneLine.isEmpty() )
               {
                  break;
               }
            }
            // Read the entity body (if there is one).
            while ( (oneLine = in.readLine()) != null )
            {
               System.out.println(oneLine);
            }
         }
         catch (IOException e)
         {
            System.out.println("CLIENT: Cannot receive response from server.");
            System.out.println( e );
         }
      }
      catch (IOException e)
      {
         System.out.println("CLIENT: Cannot connect to server.");
         e.printStackTrace();
         System.exit(-1);
      }
      System.out.println("CLIENT: Closed socket.");
   }
}
