/*
   This program reads 16 bytes of data from
   standard input and interprets those bytes
   as eight shorts (each short is two bytes).

   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsShort  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsShort
*/

import java.io.*;

public class ReadDataAsShort
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      try
      {
         final short n1 = in.readShort();
         final short n2 = in.readShort();
         final short n3 = in.readShort();
         final short n4 = in.readShort();
         final short n5 = in.readShort();
         final short n6 = in.readShort();
         final short n7 = in.readShort();
         final short n8 = in.readShort();
       //final short n9 = in.readShort();

         System.out.println(n1);
         System.out.println(n2);
         System.out.println(n3);
         System.out.println(n4);
         System.out.println(n5);
         System.out.println(n6);
         System.out.println(n7);
         System.out.println(n8);

         // Do the reverse of what we just did.
         //DataOutputStream out = new DataOutputStream(System.out);
         //out.writeShort(n1);
         //out.writeShort(n2);
         //out.writeShort(n3);
         //out.writeShort(n4);
         //out.writeShort(n5);
         //out.writeShort(n6);
         //out.writeShort(n7);
         //out.writeShort(n8);
         //out.flush();
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html#readShort()
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html#readShort()
