/*
   This program reads 16 bytes of data from
   standard input and interprets those bytes
   as two longs (each long is eight bytes).

   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsLong  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsLong
*/

import java.io.*;

public class ReadDataAsLong
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      try
      {
         final long n1 = in.readLong();
         final long n2 = in.readLong();

         System.out.println(n1);
         System.out.println(n2);

         // Do the reverse of what we just did.
         //DataOutputStream out = new DataOutputStream(System.out);
         //out.writeLong(n1);
         //out.writeLong(n2);
         //out.flush();
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html#readLong()
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html#readLong()
