/*
   This program reads 16 bytes of data from
   standard input and interprets those bytes
   as four floats (each float is four bytes).

   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsFloat  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsFloat
*/

import java.io.*;

public class ReadDataAsFloat
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      try
      {
         final float n1 = in.readFloat();
         final float n2 = in.readFloat();
         final float n3 = in.readFloat();
         final float n4 = in.readFloat();

         System.out.println(n1);
         System.out.println(n2);
         System.out.println(n3);
         System.out.println(n4);

         // Do the reverse of what we just did.
         //DataOutputStream out = new DataOutputStream(System.out);
         //out.writeFloat(n1);
         //out.writeFloat(n2);
         //out.writeFloat(n3);
         //out.writeFloat(n4);
         //out.flush();
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html#readFloat()
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html#readFloat()
